/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.basic.BasicSplitPaneDivider;
import com.sun.java.swing.plaf.basic.BasicSplitPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class MotifSplitPaneDivider
extends BasicSplitPaneDivider {
    public static final int minimumThumbSize = 6;
    public static final int defaultDividerSize = 18;
    protected static final int pad = 6;
    protected int hThumbWidth = 12;
    protected int hThumbHeight = 18;
    protected int vThumbWidth = 18;
    protected int vThumbHeight = 12;
    protected Color highlightColor = UIManager.getColor((Object)"SplitPane.highlight");
    protected Color shadowColor = UIManager.getColor((Object)"SplitPane.shadow");

    public MotifSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setDividerSize(this.hThumbWidth + 6);
    }

    public void setDividerSize(int n) {
        if (n < 12) {
            this.setDividerSize(12);
            return;
        }
        this.vThumbHeight = this.hThumbWidth = n - 6;
        super.setDividerSize(n);
    }

    public void paint(Graphics graphics) {
        ((Component)((Object)this)).getBackground();
        Dimension dimension = ((Component)((Object)this)).getSize();
        graphics.setColor(((Component)((Object)this)).getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int n = dimension.width / 2;
            int n2 = dimension.width / 2 - this.hThumbWidth / 2;
            int n3 = 30;
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n - 1, 0, n - 1, dimension.height);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n, 0, n, dimension.height);
            graphics.setColor(((Component)((Object)this)).getBackground());
            graphics.fillRect(n2 + 1, n3 + 1, this.hThumbWidth - 2, this.hThumbHeight - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n2, n3, n2 + this.hThumbWidth - 1, n3);
            graphics.drawLine(n2, n3 + 1, n2, n3 + this.hThumbHeight - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n2 + 1, n3 + this.hThumbHeight - 1, n2 + this.hThumbWidth - 1, n3 + this.hThumbHeight - 1);
            graphics.drawLine(n2 + this.hThumbWidth - 1, n3 + 1, n2 + this.hThumbWidth - 1, n3 + this.hThumbHeight - 2);
        } else {
            int n = dimension.height / 2;
            int n4 = dimension.width - 40;
            int n5 = dimension.height / 2 - this.vThumbHeight / 2;
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, n - 1, dimension.width, n - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, n, dimension.width, n);
            graphics.setColor(((Component)((Object)this)).getBackground());
            graphics.fillRect(n4 + 1, n5 + 1, this.vThumbWidth - 1, this.vThumbHeight - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n4, n5, n4 + this.vThumbWidth, n5);
            graphics.drawLine(n4, n5 + 1, n4, n5 + this.vThumbHeight);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n4 + 1, n5 + this.vThumbHeight, n4 + this.vThumbWidth, n5 + this.vThumbHeight);
            graphics.drawLine(n4 + this.vThumbWidth, n5 + 1, n4 + this.vThumbWidth, n5 + this.vThumbHeight - 1);
        }
        super.paint(graphics);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

